export enum UserRole {
  MASTER = 'Master',
  DILIGENCIADOR = 'Diligenciador',
  ALMOXARIFE = 'Almoxarife',
  CONFERENTE = 'Conferente',
}

export enum NFStatus {
  PENDENTE = 'Pendente',
  RECEBIDO = 'Recebido',
  CONFERIDO = 'Conferido',
}

export interface HistoryEntry {
  status: NFStatus;
  date: string; // ISO 8601 format
  user: UserRole;
}

export interface NotaFiscal {
  id: string;
  numeroNF: string;
  numeroPedido: string;
  fornecedor: string;
  dataPrevisao: string;
  dataEmissao: string;
  numeroCTE?: string;
  observacao?: string;
  status: NFStatus;
  dataRecebimento?: string;
  dataConferencia?: string;
  volumesRecebidos?: number;
  history: HistoryEntry[];
  grdId?: string;
  grdNumero?: number;
}

export interface Fornecedor {
    id: string;
    nome: string;
}

export interface GRD {
  id: string;
  numeroGRD: number;
  dataEmissao: string;
  nfIds: string[];
  observacao?: string;
}

export interface User {
  id: string;
  nome: string;
  role: UserRole;
  email?: string;
  photo_url?: string;
}