import { request } from './http';

export type CreateUserInput = {
  nome: string;
  email: string;
  role: string;
  password: string;
};

export async function createUser(payload: CreateUserInput) {
  return request('/api/users', {
    method: 'POST',
    body: JSON.stringify(payload),
  });
}

export async function getMe(): Promise<{ id: string; nome: string; email: string; role: string; photo_url?: string }> {
  return request('/api/users/me', { method: 'GET' });
}

export async function updateMe(payload: { nome?: string; email?: string }): Promise<{ id: string; nome: string; email: string; role: string; photo_url?: string }> {
  return request('/api/users/me', {
    method: 'PUT',
    body: JSON.stringify(payload),
  });
}

export async function changePassword(payload: { currentPassword: string; newPassword: string }) {
  return request('/api/users/me/password', {
    method: 'POST',
    body: JSON.stringify(payload),
  });
}

export async function uploadPhoto(file: File): Promise<{ photo_url: string }> {
  const formData = new FormData();
  formData.append('photo', file);
  return request('/api/users/me/photo', {
    method: 'POST',
    // Com FormData não definimos Content-Type, o browser define automaticamente
    body: formData,
  });
}