import { request } from './http';

export async function getFornecedores() {
  return request('/api/fornecedores');
}

export async function createFornecedor(nome: string) {
  return request('/api/fornecedores', {
    method: 'POST',
    body: JSON.stringify({ nome }),
  });
}

export async function updateFornecedor(id: string, nome: string) {
  return request(`/api/fornecedores/${id}`, {
    method: 'PUT',
    body: JSON.stringify({ nome }),
  });
}

export async function deleteFornecedor(id: string) {
  return request(`/api/fornecedores/${id}`, {
    method: 'DELETE',
  });
}