import mysql from 'mysql2/promise';

export function createPool() {
  const {
    DB_HOST = 'localhost',
    DB_USER = 'root',
    DB_PASSWORD = '',
    DB_NAME = 'my_gestao_entrega',
    DB_PORT = '3306',
  } = process.env;

  return mysql.createPool({
    host: DB_HOST,
    user: DB_USER,
    password: DB_PASSWORD,
    database: DB_NAME,
    port: Number(DB_PORT),
    waitForConnections: true,
    connectionLimit: 10,
    queueLimit: 0,
  });
}

export async function initDb(pool) {
  // Create tables if they don't exist
  await pool.query(`CREATE TABLE IF NOT EXISTS fornecedores (
    id CHAR(36) PRIMARY KEY,
    nome VARCHAR(255) NOT NULL UNIQUE
  )`);

  await pool.query(`CREATE TABLE IF NOT EXISTS notas_fiscais (
    id CHAR(36) PRIMARY KEY,
    numero_nf VARCHAR(50) NOT NULL,
    numero_pedido VARCHAR(50) NOT NULL,
    fornecedor_id CHAR(36) NOT NULL,
    data_previsao DATE NOT NULL,
    data_emissao DATE NOT NULL,
    numero_cte VARCHAR(50),
    observacao TEXT,
    status VARCHAR(20) NOT NULL,
    data_recebimento DATE,
    data_conferencia DATE,
    volumes_recebidos INT,
    CONSTRAINT fk_nf_fornecedor FOREIGN KEY (fornecedor_id) REFERENCES fornecedores(id)
  )`);

  await pool.query(`CREATE TABLE IF NOT EXISTS nf_history (
    id BIGINT AUTO_INCREMENT PRIMARY KEY,
    nf_id CHAR(36) NOT NULL,
    status VARCHAR(20) NOT NULL,
    date DATETIME NOT NULL,
    user VARCHAR(20) NOT NULL,
    CONSTRAINT fk_history_nf FOREIGN KEY (nf_id) REFERENCES notas_fiscais(id)
  )`);

  await pool.query(`CREATE TABLE IF NOT EXISTS grds (
    id CHAR(36) PRIMARY KEY,
    numero_grd INT NOT NULL UNIQUE,
    data_emissao DATETIME NOT NULL,
    observacao TEXT
  )`);

  await pool.query(`CREATE TABLE IF NOT EXISTS grd_nf (
    grd_id CHAR(36) NOT NULL,
    nf_id CHAR(36) NOT NULL,
    PRIMARY KEY (grd_id, nf_id),
    CONSTRAINT fk_grd_nf_grd FOREIGN KEY (grd_id) REFERENCES grds(id),
    CONSTRAINT fk_grd_nf_nf FOREIGN KEY (nf_id) REFERENCES notas_fiscais(id)
  )`);
}