'use strict';

const { randomUUID } = require('crypto');

module.exports = {
  async up(queryInterface, Sequelize) {
    const fornecedorNomes = [
      'FORNECEDOR ALPHA',
      'FORNECEDOR BETA',
      'FORNECEDOR GAMA',
      'FORNECEDOR DELTA',
    ];

    const [forRows] = await queryInterface.sequelize.query(
      `SELECT id, nome FROM fornecedores WHERE nome IN (:nomes)`,
      { replacements: { nomes: fornecedorNomes } }
    );
    const fornMap = new Map(forRows.map(r => [r.nome, r.id]));

    const demoNfs = [
      {
        numero_nf: '12345',
        numero_pedido: 'PO-001',
        fornecedor_nome: 'FORNECEDOR ALPHA',
        data_emissao: '2024-07-15',
        data_previsao: '2024-07-20',
        numero_cte: null,
        observacao: 'Entrega urgente.',
        status: 'Conferido',
      },
      {
        numero_nf: '67890',
        numero_pedido: 'PO-002',
        fornecedor_nome: 'FORNECEDOR BETA',
        data_emissao: '2024-07-16',
        data_previsao: '2024-07-22',
        numero_cte: 'CTE-554433',
        observacao: null,
        status: 'Recebido',
      },
      {
        numero_nf: '11223',
        numero_pedido: 'PO-003',
        fornecedor_nome: 'FORNECEDOR GAMA',
        data_emissao: '2024-07-20',
        data_previsao: '2024-07-25',
        numero_cte: null,
        observacao: null,
        status: 'Pendente',
      },
      {
        numero_nf: '44556',
        numero_pedido: 'PO-004',
        fornecedor_nome: 'FORNECEDOR DELTA',
        data_emissao: '2024-07-21',
        data_previsao: '2024-07-26',
        numero_cte: null,
        observacao: 'Material frágil, manusear com cuidado.',
        status: 'Pendente',
      },
    ];

    const [existingRows] = await queryInterface.sequelize.query(
      `SELECT numero_nf FROM notas_fiscais WHERE numero_nf IN (:nums)`,
      { replacements: { nums: demoNfs.map(n => n.numero_nf) } }
    );
    const existing = new Set(existingRows.map(r => r.numero_nf));
    const registros = demoNfs
      .filter(nf => !existing.has(nf.numero_nf))
      .map(nf => ({
        id: randomUUID(),
        numero_nf: nf.numero_nf,
        numero_pedido: nf.numero_pedido,
        fornecedor_id: fornMap.get(nf.fornecedor_nome),
        data_previsao: new Date(nf.data_previsao),
        data_emissao: new Date(nf.data_emissao),
        numero_cte: nf.numero_cte,
        observacao: nf.observacao,
        status: nf.status,
      }));

    if (registros.length > 0) {
      await queryInterface.bulkInsert('notas_fiscais', registros);
    }
  },

  async down(queryInterface, Sequelize) {
    await queryInterface.bulkDelete('notas_fiscais', {
      numero_nf: { [Sequelize.Op.in]: ['12345', '67890', '11223', '44556'] },
    });
  },
};