'use strict';

const { randomUUID } = require('crypto');

module.exports = {
  async up(queryInterface, Sequelize) {
    const nomes = [
      'FORNECEDOR ALPHA',
      'FORNECEDOR BETA',
      'FORNECEDOR GAMA',
      'FORNECEDOR DELTA',
    ];

    const [existingRows] = await queryInterface.sequelize.query(
      `SELECT nome FROM fornecedores WHERE nome IN (:nomes)`,
      { replacements: { nomes } }
    );
    const existing = new Set(existingRows.map(r => r.nome));
    const fornecedores = nomes
      .filter(nome => !existing.has(nome))
      .map(nome => ({
        id: randomUUID(),
        nome,
      }));

    if (fornecedores.length > 0) {
      await queryInterface.bulkInsert('fornecedores', fornecedores);
    }
  },

  async down(queryInterface, Sequelize) {
    await queryInterface.bulkDelete('fornecedores', {
      nome: { [Sequelize.Op.in]: [
        'FORNECEDOR ALPHA',
        'FORNECEDOR BETA',
        'FORNECEDOR GAMA',
        'FORNECEDOR DELTA',
      ] },
    });
  },
};