'use strict';

const bcrypt = require('bcryptjs');
const { randomUUID } = require('crypto');

module.exports = {
  async up(queryInterface, Sequelize) {
    const users = [
      {
        id: randomUUID(),
        nome: 'Master User',
        email: 'master@myapp.local',
        role: 'Master',
        password_hash: await bcrypt.hash('Master@123', 10),
      },
      {
        id: randomUUID(),
        nome: 'Diligenciador',
        email: 'diligenciador@myapp.local',
        role: 'Diligenciador',
        password_hash: await bcrypt.hash('Diligencia@123', 10),
      },
      {
        id: randomUUID(),
        nome: 'Almoxarife',
        email: 'almoxarife@myapp.local',
        role: 'Almoxarife',
        password_hash: await bcrypt.hash('Almoxarife@123', 10),
      },
      {
        id: randomUUID(),
        nome: 'Conferente',
        email: 'conferente@myapp.local',
        role: 'Conferente',
        password_hash: await bcrypt.hash('Conferente@123', 10),
      },
    ];
    const emails = users.map(u => u.email);
    const [existingRows] = await queryInterface.sequelize.query(
      `SELECT email FROM users WHERE email IN (:emails)`,
      { replacements: { emails } }
    );
    const existing = new Set(existingRows.map(r => r.email));
    const toInsert = users
      .filter(u => !existing.has(u.email))
      .map(u => ({
        ...u,
        created_at: new Date(),
        updated_at: new Date(),
      }));

    if (toInsert.length > 0) {
      await queryInterface.bulkInsert('users', toInsert);
    }
  },

  async down(queryInterface, Sequelize) {
    await queryInterface.bulkDelete('users', {
      email: {
        [Sequelize.Op.in]: [
          'master@myapp.local',
          'diligenciador@myapp.local',
          'almoxarife@myapp.local',
          'conferente@myapp.local',
        ],
      },
    });
  },
};