'use strict';

module.exports = {
  async up(queryInterface, Sequelize) {
    // Add data_emissao and observacao to grds if they don't exist
    const [col1] = await queryInterface.sequelize.query("SHOW COLUMNS FROM grds LIKE 'data_emissao'");
    if (!Array.isArray(col1) || col1.length === 0) {
      await queryInterface.sequelize.query("ALTER TABLE grds ADD COLUMN data_emissao DATETIME DEFAULT CURRENT_TIMESTAMP");
    }

    const [col2] = await queryInterface.sequelize.query("SHOW COLUMNS FROM grds LIKE 'observacao'");
    if (!Array.isArray(col2) || col2.length === 0) {
      await queryInterface.sequelize.query("ALTER TABLE grds ADD COLUMN observacao TEXT NULL");
    }
  },
  async down(queryInterface, Sequelize) {
    const [col1] = await queryInterface.sequelize.query("SHOW COLUMNS FROM grds LIKE 'data_emissao'");
    if (Array.isArray(col1) && col1.length > 0) {
      await queryInterface.sequelize.query("ALTER TABLE grds DROP COLUMN data_emissao");
    }

    const [col2] = await queryInterface.sequelize.query("SHOW COLUMNS FROM grds LIKE 'observacao'");
    if (Array.isArray(col2) && col2.length > 0) {
      await queryInterface.sequelize.query("ALTER TABLE grds DROP COLUMN observacao");
    }
  }
};