'use strict';

module.exports = {
  async up(queryInterface, Sequelize) {
    await queryInterface.sequelize.query(`
      CREATE TABLE IF NOT EXISTS grd_nf (
        id INT AUTO_INCREMENT PRIMARY KEY,
        grd_id VARCHAR(36) NOT NULL,
        nf_id VARCHAR(36) NOT NULL,
        created_at DATETIME DEFAULT CURRENT_TIMESTAMP,
        CONSTRAINT fk_grdnf_grd FOREIGN KEY (grd_id) REFERENCES grds(id) ON DELETE CASCADE,
        CONSTRAINT fk_grdnf_nf FOREIGN KEY (nf_id) REFERENCES notas_fiscais(id) ON DELETE CASCADE
      ) ENGINE=InnoDB;
    `);
  },
  async down(queryInterface, Sequelize) {
    await queryInterface.sequelize.query('DROP TABLE IF EXISTS grd_nf;');
  }
};